unit Helper;

interface

  uses System.Web, System.Configuration, DBAlias;

type
  THelper = class
  private
    { Private Declarations }
  public
    constructor Create;

    class function ConnectionString : string;
    class function ConnectionOptions : string;
    class function CookieName : string;
    class function MasterAdminID : integer;
    class function ImagesPath : string;
    class function ImagesThumbsPath : string;
    class function VirtualImagePath : string;
    class function VirtualImageThumbsPath: string;
  end;

  TLinkList = class
    public
      fLink : string;
      fUrl: string;
      constructor Create(ALink, AURL:string); override;
    published
      property Link : string read FLink write FLink;
      property URL : string read FURL write FURL;
  end;

implementation


class function THelper.ConnectionString: string;
begin
  Result := TDBAlias(HttpContext.Current.Session['TDBAlias']).ConnectionString;
end;

class function THelper.ConnectionOptions: string;
begin
  Result := TDBAlias(HttpContext.Current.Session['TDBAlias']).ConnectionOptions;
end;

class function THelper.CookieName: string;
begin
  result := ConfigurationSettings.AppSettings.Get('CookieName');
end;

class function THelper.MasterAdminID: integer;
begin
  result := Convert.ToInt32(ConfigurationSettings.AppSettings.Get('MasterAdminID'));
end;

class function THelper.ImagesPath: string;
begin
  Result := TDBAlias(HttpContext.Current.Session['TDBAlias']).ImagesPath;
end;

class function THelper.ImagesThumbsPath: string;
begin
  Result := TDBAlias(HttpContext.Current.Session['TDBAlias']).ImagesThumbsPath;
end;

class function THelper.VirtualImagePath: string;
begin
  Result := TDBAlias(HttpContext.Current.Session['TDBAlias']).VirtualImagePath;
end;

class function THelper.VirtualImageThumbsPath: string;
begin
  Result := TDBAlias(HttpContext.Current.Session['TDBAlias']).VirtualImageThumbsPath;
end;


constructor THelper.Create;
begin
  inherited Create;
  // TODO: Add any constructor code here
end;


{ TLinkList }

constructor TLinkList.Create(ALink, AURL:string);
begin
  inherited create;
  self.fLink := ALink;
  self.fUrl := Aurl;
end;







end.
